#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTest.VAL;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.VAL.UnitTests
{
	[TestFixture]
	public class VAL_HcpcsCodes : BaseTest 
	{
		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			VistALinkUnitTestHarness.RequireConnection();
		}

		[TearDown]
		protected void TearDown()
		{
			VistALinkUnitTestHarness.ReleaseConnection();
		}

		[Test]
		public void GetHcpcsCodesData_Pass()
		{
			DataTable dtTest = DAL.VAL.HcpcsCodes.GetHcpcsCodes();

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(3, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(Common.VbecsTables.HcpcsCache.HcpcsCode), Common.VbecsTables.HcpcsCache.HcpcsCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(Common.VbecsTables.HcpcsCache.HcpcsName), Common.VbecsTables.HcpcsCache.HcpcsName);
			Assert.AreEqual(true, dtTest.Columns.Contains(Common.VbecsTables.HcpcsCache.LastUpdateDate), Common.VbecsTables.HcpcsCache.LastUpdateDate);
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetHcpcsCodesData_Fail()
		{
			//New caching implementation prevents failure
		}
	}
}
#endif
